/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.internal.contentAssist.ContentAssistUtils;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.AbstractPHPEntryValue;
import com.aptana.editor.php.internal.indexer.IModifiableElementsIndex;
import com.aptana.editor.php.internal.indexer.NamespacePHPEntryValue;
import com.aptana.editor.php.internal.indexer.UnpackedEntry;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import gnu.trove.map.hash.TShortObjectHashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

public class UnpackedElementIndex
implements IModifiableElementsIndex {
    protected THashMap<IModule, List<UnpackedEntry>> entries = new THashMap();
    private TObjectLongHashMap<IModule> timeStamps = new TObjectLongHashMap();
    private TIntObjectHashMap<THashMap<String, Object>> pathToEntries = new TIntObjectHashMap();
    private TIntObjectHashMap<TShortObjectHashMap<Object>> firstCharToEntries = new TIntObjectHashMap();
    private TIntObjectHashMap<TIntObjectHashMap<Object>> firstTwoCharsToEntries = new TIntObjectHashMap();
    private ByteBuffer converter = ByteBuffer.allocate(4);

    public void recordTimeStamp(IModule m, long timeStamp) {
        try {
            this.timeStamps.put((Object)m, timeStamp);
        }
        catch (Exception e) {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)("Error recording timestamp for " + m.getFullPath()), (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
        }
    }

    public long getTimeStamp(IModule m) {
        return this.timeStamps.get((Object)m);
    }

    @Override
    public synchronized IElementEntry addEntry(int category, String entryPath, Object value, IModule module) {
        UnpackedEntry entry = new UnpackedEntry(category, entryPath, value, module);
        this.addEntryToModuleList(module, entry);
        this.addEntryToPathToEntriesMap(entry);
        this.addEntryToFirstCharToEntriesMap(entry);
        this.addEntryToFirstTwoCharsToEntriesMap(entry);
        return entry;
    }

    @Override
    public synchronized void removeModuleEntries(IModule module) {
        List entriesToRemove = (List)this.entries.get((Object)module);
        if (entriesToRemove != null && !entriesToRemove.isEmpty()) {
            for (UnpackedEntry entryToRemove : entriesToRemove) {
                this.removeEntriesFromPathToEntries(entryToRemove);
                this.removeEntriesFromFirstCharToEntries(entryToRemove);
                this.removeEntriesFromFirstTwoCharcToEntries(entryToRemove);
            }
        }
        this.timeStamps.remove((Object)module);
        this.entries.remove((Object)module);
    }

    @Override
    public synchronized List<IElementEntry> getEntriesStartingWith(int category, String path) {
        Object objResult;
        TShortObjectHashMap map;
        int indexOf = path.lastIndexOf(92);
        String namespace = null;
        boolean filterByNamespace = ContentAssistUtils.isFilterByNamespace();
        if (indexOf != -1) {
            namespace = path.substring(0, indexOf);
            path = path.substring(indexOf + 1);
        }
        final String lowerCasepath = path.toLowerCase();
        final ArrayList<IElementEntry> toReturn = new ArrayList<IElementEntry>();
        if (lowerCasepath.length() == 0) {
            if (category == -1) {
                this.entries.forEachValue((TObjectProcedure)new TObjectProcedure<List<UnpackedEntry>>(){

                    public boolean execute(List<UnpackedEntry> list) {
                        toReturn.addAll(list);
                        return true;
                    }
                });
            } else {
                TShortObjectHashMap map2 = (TShortObjectHashMap)this.firstCharToEntries.get(category);
                if (map2 != null) {
                    map2.forEachValue((TObjectProcedure)new TObjectProcedure<Object>(){

                        public boolean execute(Object obj) {
                            if (obj instanceof IElementEntry) {
                                toReturn.add((IElementEntry)obj);
                            } else if (obj instanceof Collection) {
                                toReturn.addAll((Collection)obj);
                            }
                            return true;
                        }
                    });
                }
            }
        } else if (lowerCasepath.length() == 1) {
            final short firstCharacter = (short)lowerCasepath.charAt(0);
            if (category == -1) {
                this.firstCharToEntries.forEachValue((TObjectProcedure)new TObjectProcedure<TShortObjectHashMap<Object>>(){

                    public boolean execute(TShortObjectHashMap<Object> map) {
                        Object objResult = map.get(firstCharacter);
                        if (objResult != null) {
                            UnpackedElementIndex.this.addObjRefToList(toReturn, objResult);
                        }
                        return true;
                    }
                });
            } else {
                map = (TShortObjectHashMap)this.firstCharToEntries.get(category);
                if (map != null && (objResult = map.get(firstCharacter)) != null) {
                    this.addObjRefToList(toReturn, objResult);
                }
            }
        } else if (lowerCasepath.length() == 2) {
            final int key = this.getIntKey(lowerCasepath);
            if (category == -1) {
                this.firstTwoCharsToEntries.forEachValue((TObjectProcedure)new TObjectProcedure<TIntObjectHashMap<Object>>(){

                    public boolean execute(TIntObjectHashMap<Object> map) {
                        Object objResult = map.get(key);
                        if (objResult != null) {
                            UnpackedElementIndex.this.addObjRefToList(toReturn, objResult);
                        }
                        return true;
                    }
                });
            } else {
                map = (TIntObjectHashMap)this.firstTwoCharsToEntries.get(category);
                if (map != null && (objResult = map.get(key)) != null) {
                    this.addObjRefToList(toReturn, objResult);
                }
            }
        } else if (lowerCasepath.length() > 2) {
            final int key = this.getIntKey(lowerCasepath);
            if (category == -1) {
                this.firstTwoCharsToEntries.forEachValue((TObjectProcedure)new TObjectProcedure<TIntObjectHashMap<Object>>(){

                    public boolean execute(TIntObjectHashMap<Object> map) {
                        Object objResult = map.get(key);
                        if (objResult != null) {
                            UnpackedElementIndex.this.addObjRefToListWithPathCheck(toReturn, objResult, lowerCasepath);
                        }
                        return true;
                    }
                });
            } else {
                map = (TIntObjectHashMap)this.firstTwoCharsToEntries.get(category);
                if (map != null && (objResult = map.get(key)) != null) {
                    this.addObjRefToListWithPathCheck(toReturn, objResult, lowerCasepath);
                }
            }
        }
        if (filterByNamespace) {
            ArrayList<IElementEntry> filter;
            if (namespace != null) {
                filter = new ArrayList<IElementEntry>();
                for (IElementEntry e : toReturn) {
                    AbstractPHPEntryValue m;
                    String nameSpace2;
                    Object value = e.getValue();
                    if (!(value instanceof AbstractPHPEntryValue) || (nameSpace2 = (m = (AbstractPHPEntryValue)value).getNameSpace()) == null || !nameSpace2.equals(namespace)) continue;
                    filter.add(e);
                }
                return filter;
            }
            filter = new ArrayList();
            for (IElementEntry e : toReturn) {
                Object value = e.getValue();
                if (!(value instanceof AbstractPHPEntryValue)) continue;
                AbstractPHPEntryValue m = (AbstractPHPEntryValue)value;
                if (m instanceof NamespacePHPEntryValue) {
                    filter.add(e);
                    continue;
                }
                String nameSpace2 = m.getNameSpace();
                if (nameSpace2 != null && nameSpace2.length() != 0) continue;
                filter.add(e);
            }
            return filter;
        }
        return toReturn;
    }

    private void addObjRefToList(List<IElementEntry> list, Object reference) {
        if (reference instanceof IElementEntry) {
            list.add((IElementEntry)reference);
        } else if (reference instanceof Collection) {
            list.addAll((Collection)reference);
        }
    }

    private void addObjRefToListWithPathCheck(List<IElementEntry> list, Object reference, String lowerCasePath) {
        if (reference instanceof IElementEntry) {
            if (((IElementEntry)reference).getLowerCaseEntryPath().startsWith(lowerCasePath)) {
                list.add((IElementEntry)reference);
            }
        } else if (reference instanceof Collection) {
            for (IElementEntry currentEntry : (Collection)reference) {
                if (!currentEntry.getLowerCaseEntryPath().startsWith(lowerCasePath)) continue;
                list.add(currentEntry);
            }
        }
    }

    @Override
    public synchronized List<IElementEntry> getEntries(int category, String path) {
        int indexOf = path.lastIndexOf(92);
        boolean filterByNamespace = ContentAssistUtils.isFilterByNamespace();
        String namespace = null;
        if (indexOf != -1) {
            namespace = path.substring(0, indexOf);
            path = path.substring(indexOf + 1);
        }
        final String lowerCasePath = path.toLowerCase();
        if (category == -1) {
            final ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
            this.pathToEntries.forEachValue((TObjectProcedure)new TObjectProcedure<THashMap<String, Object>>(){

                public boolean execute(THashMap<String, Object> map) {
                    Object resultObject = map.get((Object)lowerCasePath);
                    if (resultObject == null) {
                        return true;
                    }
                    if (resultObject instanceof Collection) {
                        result.addAll((Collection)resultObject);
                    } else if (resultObject instanceof IElementEntry) {
                        result.add((IElementEntry)resultObject);
                    }
                    return true;
                }
            });
            if (filterByNamespace && namespace != null) {
                ArrayList<IElementEntry> filter = new ArrayList<IElementEntry>();
                for (IElementEntry e : result) {
                    AbstractPHPEntryValue m;
                    String nameSpace2;
                    Object value = e.getValue();
                    if (!(value instanceof AbstractPHPEntryValue) || (nameSpace2 = (m = (AbstractPHPEntryValue)value).getNameSpace()) == null || !nameSpace2.equals(namespace)) continue;
                    filter.add(e);
                }
                return filter;
            }
            return result;
        }
        Map map = (Map)this.pathToEntries.get(category);
        if (map == null) {
            return Collections.emptyList();
        }
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        Object resultObject = map.get(lowerCasePath);
        if (resultObject == null) {
            return Collections.emptyList();
        }
        if (resultObject instanceof Collection) {
            result.addAll((Collection)resultObject);
        } else if (resultObject instanceof IElementEntry) {
            result.add((IElementEntry)resultObject);
        }
        if (filterByNamespace && namespace != null) {
            ArrayList<IElementEntry> filter = new ArrayList<IElementEntry>();
            for (IElementEntry e : result) {
                AbstractPHPEntryValue m;
                String nameSpace2;
                Object value = e.getValue();
                if (!(value instanceof AbstractPHPEntryValue) || (nameSpace2 = (m = (AbstractPHPEntryValue)value).getNameSpace()) == null || !nameSpace2.equals(namespace)) continue;
                filter.add(e);
            }
            return filter;
        }
        return result;
    }

    public synchronized int size() {
        int size = 0;
        for (List moduleEntries : this.entries.values()) {
            size += moduleEntries.size();
        }
        return size;
    }

    @Override
    public synchronized List<IElementEntry> getModuleEntries(IModule module) {
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        List moduleEntries = (List)this.entries.get((Object)module);
        if (moduleEntries != null) {
            result.addAll(moduleEntries);
        }
        return result;
    }

    @Override
    public synchronized Set<IModule> getModules() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    public IModule[] getAllModules() {
        return (IModule[])this.timeStamps.keys((Object[])new IModule[this.timeStamps.size()]);
    }

    private void removeEntriesFromFirstTwoCharcToEntries(UnpackedEntry entryToRemove) {
        TIntObjectHashMap map = (TIntObjectHashMap)this.firstTwoCharsToEntries.get(entryToRemove.getCategory());
        if (map == null) {
            return;
        }
        String lowerCasePath = entryToRemove.getLowerCaseEntryPath();
        if (lowerCasePath.length() < 2) {
            return;
        }
        int key = this.getIntKey(lowerCasePath);
        Object pathToEntriesValue = map.get(key);
        if (pathToEntriesValue == null) {
            return;
        }
        if (pathToEntriesValue instanceof UnpackedEntry) {
            if (entryToRemove.equals(pathToEntriesValue)) {
                map.remove(key);
            }
        } else if (pathToEntriesValue instanceof Collection) {
            Iterator it = ((Collection)pathToEntriesValue).iterator();
            while (it.hasNext()) {
                IElementEntry currentEntry = (IElementEntry)it.next();
                if (!lowerCasePath.equals(currentEntry.getLowerCaseEntryPath()) || !entryToRemove.getModule().equals(currentEntry.getModule())) continue;
                it.remove();
            }
            if (((Collection)pathToEntriesValue).size() == 0) {
                map.remove(key);
            }
        }
    }

    private int getIntKey(String lowerCasePath) {
        short firstCharacter = (short)lowerCasePath.charAt(0);
        short secondCharacter = (short)lowerCasePath.charAt(1);
        this.converter.clear();
        this.converter.putShort(firstCharacter);
        this.converter.putShort(secondCharacter);
        this.converter.flip();
        int key = this.converter.getInt();
        return key;
    }

    private void removeEntriesFromFirstCharToEntries(UnpackedEntry entryToRemove) {
        TShortObjectHashMap map = (TShortObjectHashMap)this.firstCharToEntries.get(entryToRemove.getCategory());
        if (map == null) {
            return;
        }
        String lowerCasePath = entryToRemove.getLowerCaseEntryPath();
        if (lowerCasePath.length() == 0) {
            return;
        }
        short firstCharacter = (short)lowerCasePath.charAt(0);
        Object pathToEntriesValue = map.get(firstCharacter);
        if (pathToEntriesValue == null) {
            return;
        }
        if (pathToEntriesValue instanceof UnpackedEntry) {
            if (entryToRemove.equals(pathToEntriesValue)) {
                map.remove(firstCharacter);
            }
        } else if (pathToEntriesValue instanceof Collection) {
            Iterator it = ((Collection)pathToEntriesValue).iterator();
            while (it.hasNext()) {
                IElementEntry currentEntry = (IElementEntry)it.next();
                if (!lowerCasePath.equals(currentEntry.getLowerCaseEntryPath()) || !entryToRemove.getModule().equals(currentEntry.getModule())) continue;
                it.remove();
            }
            if (((Collection)pathToEntriesValue).size() == 0) {
                map.remove(firstCharacter);
            }
        }
    }

    private void removeEntriesFromPathToEntries(UnpackedEntry entryToRemove) {
        Map map = (Map)this.pathToEntries.get(entryToRemove.getCategory());
        if (map == null) {
            return;
        }
        Object pathToEntriesValue = map.get(entryToRemove.getLowerCaseEntryPath());
        if (pathToEntriesValue == null) {
            return;
        }
        if (pathToEntriesValue instanceof UnpackedEntry) {
            if (entryToRemove.equals(pathToEntriesValue)) {
                map.remove(entryToRemove.getLowerCaseEntryPath());
            }
        } else if (pathToEntriesValue instanceof Collection) {
            Iterator it = ((Collection)pathToEntriesValue).iterator();
            while (it.hasNext()) {
                IElementEntry currentEntry = (IElementEntry)it.next();
                if (!entryToRemove.getModule().equals(currentEntry.getModule())) continue;
                it.remove();
            }
            if (((Collection)pathToEntriesValue).size() == 0) {
                map.remove(entryToRemove.getLowerCaseEntryPath());
            }
        }
    }

    private void addEntryToFirstTwoCharsToEntriesMap(UnpackedEntry entry) {
        String lowerCasePath;
        TIntObjectHashMap map = (TIntObjectHashMap)this.firstTwoCharsToEntries.get(entry.getCategory());
        if (map == null) {
            map = new TIntObjectHashMap();
            this.firstTwoCharsToEntries.put(entry.getCategory(), (Object)map);
        }
        if ((lowerCasePath = entry.getLowerCaseEntryPath()).length() < 2) {
            return;
        }
        int key = this.getIntKey(lowerCasePath);
        Object objectResult = map.get(key);
        if (objectResult == null) {
            map.put(key, (Object)entry);
        } else if (objectResult instanceof IElementEntry) {
            if (!objectResult.equals(entry)) {
                IElementEntry oldEntry = (IElementEntry)objectResult;
                HashSet<IElementEntry> list = new HashSet<IElementEntry>(2);
                list.add(oldEntry);
                list.add(entry);
                map.put(key, list);
            }
        } else if (objectResult instanceof Collection && !((HashSet)objectResult).contains(entry)) {
            ((HashSet)objectResult).add(entry);
        }
    }

    private void addEntryToFirstCharToEntriesMap(UnpackedEntry entry) {
        String lowerCasePath;
        TShortObjectHashMap map = (TShortObjectHashMap)this.firstCharToEntries.get(entry.getCategory());
        if (map == null) {
            map = new TShortObjectHashMap();
            this.firstCharToEntries.put(entry.getCategory(), (Object)map);
        }
        if ((lowerCasePath = entry.getLowerCaseEntryPath()).length() == 0) {
            return;
        }
        short firstCharacter = (short)lowerCasePath.charAt(0);
        Object objectResult = map.get(firstCharacter);
        if (objectResult == null) {
            map.put(firstCharacter, (Object)entry);
        } else if (objectResult instanceof IElementEntry) {
            if (!objectResult.equals(entry)) {
                IElementEntry oldEntry = (IElementEntry)objectResult;
                HashSet<IElementEntry> list = new HashSet<IElementEntry>(2);
                list.add(oldEntry);
                list.add(entry);
                map.put(firstCharacter, list);
            }
        } else if (objectResult instanceof Collection && !((Collection)objectResult).contains(entry)) {
            ((Collection)objectResult).add(entry);
        }
    }

    private void addEntryToPathToEntriesMap(UnpackedEntry entry) {
        Object pathToEntriesValue;
        int category = entry.getCategory();
        String entryPathLowerCase = entry.getLowerCaseEntryPath();
        THashMap map = (THashMap)this.pathToEntries.get(category);
        if (map == null) {
            map = new THashMap();
            this.pathToEntries.put(category, (Object)map);
        }
        if ((pathToEntriesValue = map.get((Object)entryPathLowerCase)) == null) {
            map.put((Object)entryPathLowerCase, (Object)entry);
        } else if (pathToEntriesValue instanceof UnpackedEntry) {
            if (entry.equals(pathToEntriesValue)) {
                return;
            }
            HashSet<UnpackedEntry> val = new HashSet<UnpackedEntry>(2);
            val.add((UnpackedEntry)pathToEntriesValue);
            val.add(entry);
            map.put((Object)entryPathLowerCase, val);
        } else if (pathToEntriesValue instanceof Collection) {
            Collection val = (Collection)pathToEntriesValue;
            if (val.contains(entry)) {
                return;
            }
            val.add(entry);
        }
    }

    private void addEntryToModuleList(IModule module, UnpackedEntry entry) {
        ArrayList<UnpackedEntry> moduleEntries = (ArrayList<UnpackedEntry>)this.entries.get((Object)module);
        if (moduleEntries == null) {
            moduleEntries = new ArrayList<UnpackedEntry>();
            this.entries.put((Object)module, moduleEntries);
        }
        moduleEntries.add(entry);
    }

    public void removeTimeStamp(IModule module) {
        this.timeStamps.remove((Object)module);
    }
}

